/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qlabel.h>
#include <qpixmap.h>
#include <qpainter.h>

#include "light.moc"

#include "light.data"

Light::Light(const QColor &cOn, const QColor &cOff, QWidget *parent, const char *name)
  : QLabel(parent, name),
    colorOn(cOn), colorOff(cOff)
    
{
  lightPixmap.loadFromData(light_9, light_9_size);
  lightMask.loadFromData(light_mask_9, light_mask_9_size);

  generateIcon(on, colorOn);
  generateIcon(off, colorOff);

  setSizePolicy(QSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum));

  setPixmap(off);
  _status = false;
}

void Light::setStatus(bool s)
{
  if (s == _status)
    return;

  setPixmap( s ? on : off);
  _status = s;
}

void Light::setColors(const QColor &cOn, const QColor &cOff)
{
  if (colorOn != cOn) {
    colorOn = cOn;
    generateIcon(on, colorOn);
    if (_status)
      setPixmap(on);
  }
  if (colorOff != cOff) {
    colorOff = cOff;
    generateIcon(off, colorOff);
    if (!_status)
      setPixmap(off);
  }
}

void Light::generateIcon(QPixmap &px, QColor &col)
{
  px = lightMask;
  QPainter p(&px);
  p.fillRect(0, 0, on.width()-1, on.height()-1, col);
  p.drawPixmap(0, 0, lightPixmap);
  p.end();
}


