/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef __KMODEMLIGHTAPPLET_H__
#define __KMODEMLIGHTAPPLET_H__

#include <time.h>

#include <qstring.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qlabel.h>

#include "statusbutton.h"
#include "kpanelapplet.h"


class QVBoxLayout;
class MapWidget;
class KAboutData;
class KPopupMenu;
class Light;
class Graph;

class KModemLightsApplet : public KPanelApplet
{
  Q_OBJECT
    
 public:

  KModemLightsApplet(const QString& configFile, Type t = Normal, 
		    int actions = 0, QWidget *parent = 0, 
		    const char *name = 0);
  ~KModemLightsApplet();

  int widthForHeight(int height) const;
  int heightForWidth(int width) const;
  bool getStats(int &in, int &out) const;

 public slots:

  void dial(); 

 protected:

  void mousePressEvent(QMouseEvent *);
  bool isConnected();
  bool getStats(int &in, int &out);
  int getConnectTime(bool recalcStart);

 protected slots:
 
  void timerEvent(QTimerEvent *e);
  void about();
  void preferences();

 private:

  void readConfig();

  void updateTimer();
  void updateLights(bool rx, bool tx);
  void updateLoad(unsigned int rx, unsigned int tx);
  void updateRx(int rx);
  
  // Elements of applet
  StatusButton *button;
  QLabel *showTime;
  Light *lightRx, *lightTx;
  Graph *graph;
  QLabel *showRx;
  QHBoxLayout *hbox;
  QVBoxLayout *vbox;
  KAboutData *aboutData;
  KPopupMenu *popup;

  int timerID;

  // Configurabel Entities
  QString lockFile;
  QString deviceName;
  QString connectCommand;
  QString disconnectCommand;
  int updateFrequency;

  // fonts for height
  mutable int ffhAppletHeight, ffhFontSize;

  bool useISDN;

  int socket;
  bool connectedLast;
  bool upLast;
  int oldRx, oldTx;
  int loadRx, loadTx;
  unsigned int loadCounter;
  bool lastTimeWasConnected;
  bool modemWasOn;
  time_t startTime;
  int oldTimer;
  int oldRxBytes, RxBytesShowed;
  
  friend class KModemLightsDlg;

};

#endif

/*
is_connected:  is_ISDN_on() || is_Modem_on()
get_stats:     get_ISDN_stats || get_modem_stats
get_connect_time  get_ISDN_connect_time || get_modem_connect_time
*/
