/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef KMODEMLIGHTSDLG_H
#define KMODEMLIGHTSDLG_H

#include <qspinbox.h>
#include <qlineedit.h>
#include <qfont.h>
#include <kdialogbase.h>
#include <kcolorbutton.h>

class QGrid;
class QPushButton;
class QLabel;
class KColorButton;
class KModemLightsApplet;

class KModemLightsDlg : public KDialogBase {
  Q_OBJECT
  
 public:
  KModemLightsDlg::KModemLightsDlg(QWidget *parent, const char *name,
				   KModemLightsApplet *ap);
  //    int getAngle() const { return angle; }

  // get Device
  int updateFrequency() const { return frequencyWidget->value(); };
  QString deviceName() const { return deviceWidget->text(); };
  QString lockFile() const { return lockFileWidget->text(); };
  QString connectCommand() const { return connectWidget->text(); };
  QString disconnectCommand() const { return disconnectWidget->text(); };

  // get Colors
  QColor rxOnColor() { return rxOn->color(); };
  QColor rxOffColor() { return rxOff->color(); };
  QColor rxGraphColor() { return rxGraph->color(); };
  QColor txOnColor() { return txOn->color(); };
  QColor txOffColor() { return txOff->color(); };
  QColor txGraphColor() { return txGraph->color(); };
  QColor statusAwaitColor() { return statusAwait->color(); };
  QColor statusOnColor() { return statusOn->color(); };
 private:

  void setFontShowWidget();
  QWidget *generateDevice();
  QWidget *generateColor();

  KModemLightsApplet *applet;

  // Device
  QSpinBox *frequencyWidget;
  QLineEdit *deviceWidget;
  QLineEdit *lockFileWidget;
  QLineEdit *connectWidget;
  QLineEdit *disconnectWidget;

  // Colors
  KColorButton *rxOn, *rxOff, *rxGraph;
  KColorButton *txOn, *txOff, *txGraph;
  KColorButton *statusAwait, *statusOn;

  QLabel *fontShowWidget;

 private slots:
  void help();
};

#endif
