/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <time.h>

#include <qlayout.h>
#include <qvbox.h>
#include <qiconset.h> 
#include <qsizepolicy.h> 
#include <qpainter.h>

#include <kapplication.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <krun.h>
#include <kglobalsettings.h>
#include <kmessagebox.h>
#include <kaboutapplication.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "statusbutton.moc"

#include "statusbutton.data"

StatusButton::StatusButton(QWidget *parent, const char *name)
  : QPushButton(parent, name),
    colorOn(0x00FF00), colorWait(0xFFFF00)
{
  // load all pixmaps
  signOn.loadFromData(statusbutton_on, statusbutton_on_size);
  signOff.loadFromData(statusbutton_off, statusbutton_off_size);
  signWait.loadFromData(statusbutton_neither, statusbutton_neither_size);
  signMask.loadFromData(statusbutton_mask, statusbutton_mask_size);
  
  // generate the icons
  generateIconOn();
  generateIconWait();
  off = signOff;

  // set this consitently!
  setPixmap(off);
  myStatus = Off;
}

void StatusButton::setStatus(const Status s)
{
  if (s == myStatus)
    return;

  switch(s) {
  case On:
    setPixmap(on);
    break;
  case Off:
    setPixmap(off);
    break;
  case Wait:
    setPixmap(wait);
    break;
  }
  myStatus = s;
}

void StatusButton::generateIconOn()
{
  on = signMask;
  QPainter p(&on);
  p.fillRect(0, 0, on.width()-1, on.height()-1, colorOn);
  p.drawPixmap(0, 0, signOn);
  p.end();
}

void StatusButton::generateIconWait()
{
  wait = signMask;
  QPainter p(&wait);
  p.fillRect(0, 0, on.width()-1, on.height()-1, colorWait);
  p.drawPixmap(0, 0, signWait);
  p.end();
}

void StatusButton::setColor(const Status s, const QColor &c)
{
  switch(s) {
  case On:
    if (c != colorOn) {
      colorOn = c;
      generateIconOn();
    }
    break;
  case Off:
    break;
  case Wait:
    if (c != colorWait) {
      colorWait = c;
      generateIconWait();
    }
    break;
  }
}

QColor StatusButton::getColor(const Status s)
{
  switch(s) {
  case On:
    return colorOn;
    break;
  case Off:
    return Qt::black; // HACK
    break;
  case Wait:
    return colorWait;
    break;
  default:
    return Qt::black;
    break;
  }
}
