/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef __MODEM_H__
#define __MODEM_H__

class Modem
{

 public:

  Modem();
  Modem(char *device, char *lock);
  ~Modem();

  bool isConnected() const;
  bool getStats(unsigned int &in, unsigned int &out) const;
  int getConnectTime(bool recalc);
  
  void setDeviceName(const char *deviceName);
  const char *deviceName() const { return DeviceName; };
  void setLockFile(const char *lockFile);
  const char *lockFile() const { return LockFile; };

 private:

  int socket;
  char *DeviceName;
  char *LockFile;

};

#endif
