/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef __GRAPH_H__
#define __GRAPH_H__

#include <qwidget.h>
#include <qcolor.h>

class Graph : public QWidget
{
  Q_OBJECT

 public:
  Graph(QWidget *parent = 0, const char * name = 0);
  Graph(const QColor cA, const QColor cB, const QColor cBg, 
	QWidget *parent = 0, const char * name = 0);
  ~Graph();

  virtual QSize sizeHint () const;

  void addValues(unsigned int a, unsigned int b);
  void setColorA(const QColor &);
  void setColorB(const QColor &);
  void setColorBg(const QColor &);
  QColor getColorA() const { return colorA; };
  QColor getColorB() const { return colorB; };
  QColor getColorBg() const { return colorBg; };
  void setMaxValue(unsigned int m);
  void unsetMaxValue();
  unsigned int getMaxValue() { return maxValue; };
  bool autoMax() { return autoMaxValue; };

 protected:
  virtual void resizeEvent(QResizeEvent *);
  virtual void paintEvent(QPaintEvent *);

 private:
  void setup();
  void calcMaxValue();

  // dateSamples
  struct Samples{
    unsigned int a;
    unsigned int b;
  } *dataSamples;
  size_t dataSize;
  size_t dataPtr;

  // maximum Queue
  unsigned int *dataMax;
  size_t dataMaxSize;
  size_t dataMaxPtr;
  unsigned int maxValue;
  bool autoMaxValue;

  // colors
  QColor colorA, colorB, colorBg;

};

inline QSize Graph::sizeHint () const
{
  return QSize(22, 22);
}

inline void Graph::setColorA(const QColor &a) 
{ 
  colorA = a; 
  update(); 
}

inline void Graph::setColorB(const QColor &b) 
{ 
  colorB = b; 
  update(); 
}

inline void Graph::setColorBg(const QColor &bg) 
{ 
  colorBg = bg;
  setPaletteBackgroundColor(colorBg);
  update(); 
}

#endif
