/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef __KMODEMLIGHTAPPLET_H__
#define __KMODEMLIGHTAPPLET_H__

#include <time.h>

#include <qstring.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qlabel.h>

#include "kpanelapplet.h"

#include "statusbutton.h"
#include "modem.h"


class MapWidget;
class KAboutData;
class KPopupMenu;
class Light;
class Graph;
class TRLabel;

class KModemLightsApplet : public KPanelApplet
{
  Q_OBJECT
    
 public:

  KModemLightsApplet(const QString& configFile, Type t = Normal, 
		    int actions = 0, QWidget *parent = 0, 
		    const char *name = 0);
  ~KModemLightsApplet();

  int widthForHeight(int height) const;
  int heightForWidth(int width) const;

 public slots:

  void dial(); 

 protected:

  void mousePressEvent(QMouseEvent *);

 protected slots:
 
  void timerEvent(QTimerEvent *e);
  void about();
  void preferences();

  virtual void resizeEvent(QResizeEvent *);  

 private:

  void readConfig();

  void updateTimer();
  void updateLights(bool rx, bool tx);
  void updateGraph(unsigned int rx, unsigned int tx);
  void updateRx(int rx);

  void horizontalLayout(int height);
  void verticalLayout(int width);

  // elements of applet
  StatusButton *button;
  Graph *graph;
  Light *lightRx, *lightTx;
  TRLabel *showRx;
  TRLabel *showTime;
  // layouts
  QBoxLayout *page;
  QBoxLayout *infoPart;

  KAboutData *aboutData;
  KPopupMenu *popup;

  int timerID;

  // Configurabel Entities
  QString connectCommand;
  QString disconnectCommand;
  int updateFrequency;
  bool showRequesters;
  unsigned int graphMaxValue;

  Modem modem;

  // memory for timerEvent
  unsigned int timerEventCounter;
  bool lastTimeWasConnected;
  bool modemWasOn;
  // memory for lights
  unsigned int oldRx, oldTx;
  // memory for graph
  int graphRx, graphTx;
  // memory for updateRx
  int oldRxBytes;

  friend class KModemLightsDlg;

};

#endif
