/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qlabel.h>

#include "speciallabels.moc"

TRLabel::TRLabel(QWidget *parent, const char *name, WFlags f) :
  QLabel(parent, name, f), 
  type(TRLabel::undefined)
{
  setAlignment(Qt::AlignRight|Qt::AlignVCenter);
}

void TRLabel::setTime(time_t t)
{
  if (type != TRLabel::time) {
    oldTime = t+1;
    type = TRLabel::time;
  }
  if (t != oldTime) {
    QString s;
    if (t == -1) {
      s = "      ";
    } else {
      if (t>3600) { /* HH:MM */
	t /= 60;
	s.sprintf("%02ld:%02ld ", t/60, t%60);
      } else { /* MM'SS" */
	//setText(QString().sprintf("%02d%s%02d%s", t/60, "ʹ", t%60, "ʺ"));
	s.sprintf("%02ld'%02ld\"", t/60, t%60);
      }
    }
    setText(s);
    oldTime = t;
    update();
  }
}

void TRLabel::setBytes(unsigned int b)
{
  if (type != TRLabel::bytes) {
    oldBytes = b+1;
    type = TRLabel::bytes;
  }
  if (b != oldBytes) {
    QString s;
    if(b < 10000)
      s.sprintf("%4db", b);
    else if(b < 10000000)
      s.sprintf("%4dK", b/1024);
    else
      s.sprintf("%4dM", b/(1024*1024));
    
    setText(s);
    oldBytes = b;
    update();
  }
}
