/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef KMODEMLIGHTSDLG_H
#define KMODEMLIGHTSDLG_H

#include <qspinbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qcombobox.h>

#include <kdialogbase.h>
#include <kcolorbutton.h>

#include "statusbutton.h"

class KModemLightsApplet;

class KModemLightsDlg : public KDialogBase {
  Q_OBJECT

 public:

  KModemLightsDlg::KModemLightsDlg(KModemLightsApplet *ap, QWidget *parent = 0, 
				   const char *name = 0);

  // get Device
  QString deviceName() const { return deviceWidget->text(); }
  QString lockFile() const { return lockFileWidget->text(); }
  QString connectCommand() const { return connectWidget->text(); }
  QString disconnectCommand() const { return disconnectWidget->text(); }

  // get general
  int updateFrequency() const { return frequencyWidget->value(); }
  bool showRequesters() const { return showRequestersWidget->isChecked(); }
  bool graphAutoMax() const { return autoMaxWidget->isChecked(); }
  unsigned int graphMaxValue() const { return maxValueWidget->text().toUInt(); }
  bool unlimitFontSize() const { return unlimitFontSizeWidget->isChecked(); }
  StatusButton::IconSize iconSize() const { 
    return static_cast<StatusButton::IconSize>(iconSizeWidget->currentItem()); 
  }

  // get Colors
  QColor rxOnColor() const { return rxOn->color(); }
  QColor rxOffColor() const { return rxOff->color(); }
  QColor rxGraphColor() const { return rxGraph->color(); }
  QColor txOnColor() const { return txOn->color(); }
  QColor txOffColor() const { return txOff->color(); }
  QColor txGraphColor() const { return txGraph->color(); }
  QColor statusAwaitColor() const { return statusAwait->color(); }
  QColor statusOnColor() const { return statusOn->color(); }
  QColor graphBgColor() const { return graphBg->color(); }

 private:

  QWidget *generateGeneral();
  QWidget *generateAppearance();
  QWidget *generateDevice();
  QWidget *generateColor();
  QLabel *newCaption(const QString &s, QWidget *w);

  KModemLightsApplet *applet;

  // General
  QSpinBox *frequencyWidget;
  QCheckBox *showRequestersWidget;
  QCheckBox *autoMaxWidget;
  QLineEdit *maxValueWidget;
  QCheckBox *unlimitFontSizeWidget;
  QComboBox *iconSizeWidget;

  // Device
  QLineEdit *deviceWidget;
  QLineEdit *lockFileWidget;
  QLineEdit *connectWidget;
  QLineEdit *disconnectWidget;

  // Colors
  KColorButton *rxOn, *rxOff, *rxGraph;
  KColorButton *txOn, *txOff, *txGraph;
  KColorButton *statusAwait, *statusOn;
  KColorButton *graphBg;

 private slots:

  void help();
};

#endif
