/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qpainter.h>

#include "statusbutton.moc"

#include "statusbutton.data"

StatusButton::StatusButton(QWidget *parent, const char *name)
  : QPushButton(parent, name),
    colorOn(0x00FF00), colorWait(0xFFFF00),
    myIconSize(smallIcon)
{
  // load all pixmaps
  signOn[0].loadFromData(statusbutton_on_12, statusbutton_on_12_size);
  signOff[0].loadFromData(statusbutton_off_12, statusbutton_off_12_size);
  signWait[0].loadFromData(statusbutton_neither_12, statusbutton_neither_12_size);
  signMask[0].loadFromData(statusbutton_mask_12, statusbutton_mask_12_size);

  signOn[1].loadFromData(statusbutton_on_24, statusbutton_on_24_size);
  signOff[1].loadFromData(statusbutton_off_24, statusbutton_off_24_size);
  signWait[1].loadFromData(statusbutton_neither_24, statusbutton_neither_24_size);
  signMask[1].loadFromData(statusbutton_mask_24, statusbutton_mask_24_size);

  signOn[2].loadFromData(statusbutton_on_32, statusbutton_on_32_size);
  signOff[2].loadFromData(statusbutton_off_32, statusbutton_off_32_size);
  signWait[2].loadFromData(statusbutton_neither_32, statusbutton_neither_32_size);
  signMask[2].loadFromData(statusbutton_mask_32, statusbutton_mask_32_size);

  // generate the icons
  generateIcon(on, signOn[myIconSize], colorOn);
  generateIcon(wait, signWait[myIconSize], colorWait);
  off = signOff[myIconSize];

  // set this consitently!
  setPixmap(off);
  myStatus = Off;
}

void StatusButton::setIcon(Status s)
{
  switch(s) {
  case On:
    setPixmap(on);
    break;
  case Off:
    setPixmap(off);
    break;
  case Wait:
    setPixmap(wait);
    break;
  }
}

void StatusButton::setStatus(const Status s)
{
  if (s == myStatus)
    return;

  setIcon(s);
  myStatus = s;
}

void StatusButton::setIconSize(IconSize size)
{
  if (size == myIconSize)
    return;

  myIconSize = size;
  
  // generate the icons
  generateIcon(on, signOn[myIconSize], colorOn);
  generateIcon(wait, signWait[myIconSize], colorWait);
  off = signOff[myIconSize];

  setIcon(myStatus);
}

void StatusButton::setColor(const Status s, const QColor &c)
{
  switch(s) {
  case On:
    if (c != colorOn) {
      colorOn = c;
      generateIcon(on, signOn[myIconSize], colorOn);
      if (s == myStatus) {
	setPixmap(on);
	update();
      }
    }
    break;
  case Off:
    break;
  case Wait:
    if (c != colorWait) {
      colorWait = c;
      generateIcon(wait, signWait[myIconSize], colorWait);
      if (s == myStatus) {
	setPixmap(wait);
	update();
      }
    }
    break;
  }
}

QColor StatusButton::color(const Status s) const
{
  switch(s) {
  case On:
    return colorOn;
    break;
  case Off:
    return Qt::black; // HACK
    break;
  case Wait:
    return colorWait;
    break;
  default:
    return Qt::black;
    break;
  }
}

void StatusButton::generateIcon(QPixmap &px, const QPixmap &sign, const QColor &col)
{
  px = signMask[myIconSize];
  QPainter p(&px);
  p.fillRect(0, 0, px.width()-1, px.height()-1, col);
  p.drawPixmap(0, 0, sign);
  p.end();
}

