/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef __LIGHT_H__
#define __LIGHT_H__

#include <qlabel.h>
#include <qpixmap.h>
#include <qcolor.h>

class Light : public QWidget
{
  Q_OBJECT

 public:

  Light(const QColor &cOn, const QColor &cOff, QWidget *parent, const char *name = 0);

  virtual QSize sizeHint () const { return on.size(); }

  void setStatus(bool s);
  bool status() const { return lightStatus; }
  void setColors(const QColor &cOn, const QColor &cOff);
  QColor getColorOn() const { return colorOn; }
  QColor getColorOff() const { return colorOff; }
  void setBig(bool b);
  bool big() const { return bigLights; }

 protected:

  virtual void paintEvent(QPaintEvent *);
  virtual void resizeEvent(QResizeEvent *e);

 private:

  void generateIcon(QPixmap &px, QColor &col);

  bool lightStatus;
  bool bigLights;
  QPixmap on, off;
  QColor colorOn, colorOff;
  int offx, offy;

  // one version of these is enough;
  static QPixmap lightPixmapS, lightMaskS;
  static QPixmap lightPixmapL, lightMaskL;
};

#endif
