/*
 * (c) 2004 M G Berberich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file called COPYING; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef __STATUSBUTTON_H__
#define __STATUSBUTTON_H__

#include <qpushbutton.h>

class QPixmap;
class QColor;

class StatusButton : public QPushButton
{
  Q_OBJECT

 public:

  enum IconSize { smallIcon=0, mediumIcon, largeIcon };	// these are indexes!
  enum Status { On, Off, Wait };

  StatusButton(QWidget *parent, const char *name = 0);
 
  void setStatus(const Status s);
  Status status() const { return myStatus; }

  void setColor(const Status s, const QColor &c);
  QColor color(const Status s) const;

  void setIconSize(IconSize size);
  IconSize iconSize() const { return myIconSize; }
  
 public slots:

 private:

  void generateIcon(QPixmap &px, const QPixmap &sign, const QColor &col);
  void setIcon(Status s);

  QPixmap on, off, wait;
  QPixmap signOn[3], signOff[3], signWait[3], signMask[3];
  QColor colorOn, colorWait;
  IconSize myIconSize;

  enum Status myStatus;
};

#endif
