/*
 * parser.c -- read a timespec from a string
 *
 * (c) 2001 M G Berberich <berberic@fmi.uni-passau.de> 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this progggram; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  $Id: parser.c,v 1.1 2002/10/10 16:02:22 berberic Exp $ 
 */


#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include <ctype.h>

#include "ppplog.h"

jmp_buf ljenv;

typedef enum { TOK_INT, TOK_MINUS, TOK_DOTS, TOK_END, TOK_INVALID } token_t;

/**********************************************************************/

static void minus(char **s)
{
  if (**s != '-') longjmp(ljenv, 1);
  ++(*s);
  return;
}

/**********************************************************************/

static void dots(char **s)
{
  if (**s != '.') longjmp(ljenv, 1);
  ++(*s);
  if (**s != '.') longjmp(ljenv, 1);
  ++(*s);
  return;
}

/**********************************************************************/

static void end(char **s)
{
  if (**s != '\0') longjmp(ljenv, 1);
  return;
}

/**********************************************************************/

static int integer(char **s)
{
  int value;
  char *e;
  
  value = strtol(*s, &e, 10);
  if (e == *s) longjmp(ljenv, 1);
  *s = e;
  return value;
}

/**********************************************************************/

token_t lookahead(char **s) 
{
  if (isdigit(**s)) return TOK_INT;
  switch(**s) {
  case '.': return TOK_DOTS;
  case '-': return TOK_MINUS;
  default: return TOK_INVALID;
  }
}

/**********************************************************************/

static int date(char **s)
{
  int v;

  v = integer(s)*10000;
  switch(lookahead(s)) {
  case TOK_MINUS:
    minus(s);
    switch(lookahead(s)) {
    case TOK_INT:
      v = v+integer(s)*100;
      switch(lookahead(s)) {
      case TOK_MINUS:
	minus(s);
	switch(lookahead(s)) {
	case TOK_INT:
	  v = v+integer(s);
	  return v;
	  break;
	default:
	  longjmp(ljenv, 1);
	}
        break;
      default:
        return v;
      }
      break;
    default:
      longjmp(ljenv, 1);
    }
    break;
  default:
    return v;
  }
}

/**********************************************************************/

static int dateup(int d)
{
  if (!(d%10000)) d += 1200;
  if (!(d%100)) d += 31;
  return d;
}

/**********************************************************************/

static int datedown(int d)
{
  if (!(d%10000)) d += 100;
  if (!(d%100)) d += 1;
  return d;
}

/**********************************************************************/

static void timespec(char **s, int *first, int * last)
{
  int d;
  
  switch(lookahead(s)) {
  case TOK_DOTS:
    dots(s);
    *last = dateup(date(s));
    return;
  case TOK_INT:
    d = date(s);
    *first = datedown(d);
    switch(lookahead(s)) {
    case TOK_DOTS:
      dots(s);
      switch(lookahead(s)) {
      case TOK_INT:
	*last = dateup(date(s));
	return;
      default:
	return;
      }
    default:
      *last = dateup(d);
      return;
    }
  default:
    longjmp(ljenv, 1);
  }
}

/**********************************************************************/

int parse_timespec(char **s, int *first, int *last)
{
  if (setjmp(ljenv)) return 1;

  timespec(s, first, last);
  end(s);

  return 0;
}
