/*
 * scandir.c -- find last and first recorded files
 *
 * (c) 2001 M G Berberich <berberic@fmi.uni-passau.de> 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this progggram; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  $Id: scandir.c,v 1.1 2002/10/10 16:02:22 berberic Exp $ 
 */

#include <sys/types.h>
#include <dirent.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>

#include "ppplog.h"

int getfirstlast(char *path, int *first, int *last)
{
  DIR *d;
  struct dirent *e;
  int v, f=INT_MAX, l=0;

  d = opendir(path);
  if (!d) return 1;

  while((e=readdir(d))) {
    int y, m;
    char *p1, *p2;

    y = strtol(e->d_name, &p1, 10);
    if (p1 != e->d_name+4 || *p1 != '-') continue;
    ++p1;
    m = strtol(p1, &p2, 10);
    if (p2 != p1+2 || *p2 != '\0') continue;

    v = y*100+m;
    if (f>v) f=v;
    if (l<v) l=v;
  }
  if (first) *first = f*100+1;
  if (last) *last = l*100+31;
  return 0;
}
